# Revive Old Posts - Social Media Auto Post and Scheduling Plugin #
**Contributors:** [codeinwp](https://profiles.wordpress.org/codeinwp), [marius2012](https://profiles.wordpress.org/marius2012), [marius_codeinwp](https://profiles.wordpress.org/marius_codeinwp), [hardeepasrani](https://profiles.wordpress.org/hardeepasrani), [Madalin_Themeisle](https://profiles.wordpress.org/Madalin_Themeisle), [rsocial](https://profiles.wordpress.org/rsocial), [uriahs-victor](https://profiles.wordpress.org/uriahs-victor)  
**Tags:** share to social media, auto publish, auto post, social media scheduling, social media auto posting, social media marketing, social media automation, social media sharing  
**Requires at least:** 4.7  
**Tested up to:** 5.4  
**Requires PHP:** 5.6  
**Stable tag:** trunk  


Automatically share your WordPress posts on Twitter, Facebook, LinkedIn. Get more visitors to your website and keep your content alive.

## Description ##

ROP is a **must-have** WordPress plugin created to help website administrators **boost their website traffic**, grow their **social media followers** and keep their existing **followers engaged** by **automatically** sharing posts and content from their WP site to their social media networks such as Facebook, Twitter, Google My Business, LinkedIN, Instagram, Tumblr and even Buffer.

_Over 40,000+ WP site owners trust Revive Old Posts as the go-to social media automation and scheduling plugin for WordPress._

Save time in your social media marketing efforts, add some social media automation to your workflow by using Revive Old Posts.

## Who Is Revive Old Posts For?

- Persons with **small blogs** or **websites** (ROP can share posts as well as pages and any other custom post type e.g Recipes, Books, Products etc)

- **Large blogs and sites** with thousands of **posts** or **e-commerce products**

- **[E-Commerce online stores](https://docs.revive.social/article/978-using-revive-old-posts-with-woocommerce)**

- **Social media marketers**

- **Hobby bloggers**

_Thinking of ways to grow your business? [Read why Social Media is Important.](https://revive.social/benefits-of-social-media-marketing/) But don't stop there, [learn how to create a social media marketing plan](https://revive.social/social-media-marketing-plan/)_

## How Can Revive Old Posts Help Me?

Revive Old Posts is much more than just a wp to facebook or wp to twitter plugin. ROP can be used for many use cases and help many different blogs and sites boost their social media traffic by introducing social media automation functionality to WordPress, it can act as all of the following in one:

### A WordPress **Social Media Scheduling** Plugin

With our plugin, you can set a schedule for how often you'd like your **old and newer content** to share to social media **a feature 100% FREE**.

Set how many hours should be between posts or go deeper into scheduling (PRO) by setting the time of day and days of the week you'd like the plugin to post to social media.

### A WordPress **Social Media Auto post** Plugin

Just finished writing an awesome blog post? Why wait until it gets shared? Automatically post to social media as soon as you click the publish button!

Auto posting is a handy feature for users who want to share to social media as soon as they're done creating their content.

### A WP **Scheduled Post** Plugin

Are you creating posts that get published at a later time in the future? With ROP, you can have those posts automatically published to your active social media accounts as soon as WordPress publishes those posts for you!

This feature takes into account filters you have set in the plugin settings, so it won't share Cat posts if you have added the Cat posts category to your excluded categories!

### A WordPress **Social Media Analytics** Plugin

Tired of manually adding UTM tags to posts to track the source of your traffic?

With ROP, shares to social media automatically include UTM tags to help you identify which included social networks your traffic is coming from.

Easily see how much social media auto posting is helping with your website traffic inside Google Analytics.

### A WordPress **Content Curation** Plugin

Social media marketing can be a tedious job, especially when it comes to deciding what content to share to social networks.

With our plugin, it is possible to implement curation capabilities by **filtering out** the posts you **don't want to** share to social media, with just a few clicks.

Once set, the plugin will then be able to determine which content to auto share to social media.

---

Revive Old Posts isn't like every other social media marketing tool. We've tailored its features while keeping the following in mind:

- Sustain and grow website traffic
- Grow social media following
- Keep existing social media followers engaged
- Promote and share evergreen content

**The plugin can automatically share posts from:**

- WordPress to Facebook page
- WordPress to Facebook Groups [Pro]
- WordPress to Twitter
- WordPress to Instagram [Pro]
- WordPress to Linkedin Profile [Pro]
- WordPress to Linkedin Page [Pro]
- WordPress to Tumblr [Pro]
- WordPress to Google My Business [Pro]
- WordPress to Buffer [Pro]

Some of the available networks and features require the Pro version of the plugin. Check out the free vs pro table [here.](https://docs.revive.social/article/941-revive-old-post-free-vs-pro)

### What Can I Do with Revive Old Posts?

- Automatically share **old and new post** to social media on autopilot. [Free]

- Auto post to social media on blog post publish. [Free]

- Choose the **time between** social media post shares. [Free]

- Choose the **number of posts** that the plugin share to social media. [Free]

- Choose the maximum and minimum **age of posts eligible for sharing**. [Free]

- Create **common hashtags** for post shares. [Free]

- **Automatically generate hashtags** for post shares from **tags**, **categories** or from **custom fields**. [Free]

- Include links **back to your site**. [Free]

- Compatible with **URL Shorteners**. Shorten the links for the content that you post to social media. [Free]

- **Exclude categories and tags (and other custom taxonomies)** from sharing to social media. [Free]

- **Exclude specific posts** from sharing to social media. [Free]

- Integrate with **Google Analytics** to track your social media traffic increase. [Free]

And More! Try Revive Old Posts, see why it's the **best** WordPress social media marketing tool to boost your site traffic and keep your followers engaged.


## What’s Included in Pro?

Using the PRO version of Revive Old Posts unlocks a host of additional features to help  improve social media engagement on your accounts as well as bring more social media traffic to your website.

**Awesome features in Pro:**

- [Support for WordPress Custom Post Types](https://docs.revive.social/article/968-how-to-share-different-wordpress-post-types-to-social-media-w-revive-old-posts) (WooCommerce Products, BigCommerce Products, Recipes etc.)

- [Content Variations](https://docs.revive.social/article/971-how-to-add-variations-to-revive-old-posts-shares); Add multiple share variations to your posts, including custom images, ROP will automatically choose a variation to share!

- Exclude categories and tags (and other custom taxonomies) from sharing to social media on a **per account basis**. [Learn More](https://docs.revive.social/article/591-how-to-only-share-posts-from-specific-categories-with-revive-old-post)

- Share **WordPress scheduled posts** to social media on publish. [Learn More](https://docs.revive.social/article/1194-share-scheduled-posts-to-social-media-on-publish-with-revive-old-posts)

- **WordPress to Instagram** scheduling and auto post

- **WordPress to Facebook Groups** scheduling and auto post

- **WordPress to LinkedIn Company Pages** scheduling and auto post

- **WordPress to LinkedIn Profiles** scheduling and auto post

- **WordPress to Tumblr** scheduling and auto post

- **WordPress to Google My Business** scheduling and auto post

- Connect **multiple social media accounts** to WP

- Add [custom UTM tags](https://docs.revive.social/article/925-how-to-use-custom-utm-tags) for analytics to your social media shares

- Share different [content variations](https://docs.revive.social/article/971-how-to-add-variations-to-revive-old-posts-shares) to your social networks

- Add predetermined text infront or after your post content (Additional Text)

- Add [Magic tags](https://docs.revive.social/article/952-available-magic-tags-in-revive-old-posts) to content variations

- Magic tags support for “Additional Text” option

- Automatically share images and video from your [media library to your social networks](https://docs.revive.social/article/934-how-to-use-revive-old-post-media-sharing-feature) **(our users love this feature!)**

- [Post as an image](https://docs.revive.social/article/958-how-to-share-posts-as-image-posts-to-social-accounts); share posts to social media as an image post instead of an article post.

- [Custom schedule](https://docs.revive.social/article/972-revive-old-posts-custom-schedule-feature); set the days of the week and times you'd like posts to share, social media scheduling simplified!

Post questions and issues on the [Support Forum](https://wordpress.org/support/plugin/tweet-old-post/), We’d be happy to assist you!

## Useful Resources

- See where ROP is headed, check out the roadmap [here](https://trello.com/b/svAZqXO1/roadmap-revive-old-posts).
- For plugin documentation [see here](https://docs.revive.social/).
- Read more about social media marketing on [our blog](https://revive.social/blog/).
- Read more about WordPress on [our blog](https://www.codeinwp.com/blog/).
- Take a look at our other plugins [see here](https://themeisle.com/wordpress-plugins/).



### Translations ###

* sk_SK translation by Patrik Žec [PATWIST](http://patwist.com)

## Installation ##

**The following are the steps to install the Revive Old Posts plugin**

1. In your WordPress Administration Panels, click on Add New option under Plugins from the menu.
2. Click on upload at the top.
3. Browse the location and select the Tweet old post Plugin and click install now.
4. To turn the Revive Old Posts Plugin on, click Activate.
5. Check your Administration Panels or WordPress blog to see if the Plugin is working.
6. You can change the plugin options from Revive Old Posts under settings menu.

**Alternatively, you can use the following steps to install the Revive Old Posts plugin**

1. Download the latest version of the Revive Old Posts Plugin to your computer from here.
2. With an FTP program, access your sites server.
3. Upload (copy) the Plugin file(s) or folder to the /wp-content/plugins folder.
4. In your WordPress Administration Panels, click on Plugins from the menu.
5. You should see Revive Old Posts Plugin listed. If not, with your FTP program, check the folder to see if it is installed. If it isn't, upload the file(s) again. If it is, delete the files and upload them again.
6. To turn the Revive Old Posts Plugin on, click Activate.
7. Check your Administration Panels or WordPress blog to see if the Plugin is working.
8. You can change the plugin options from Revive Old Posts under settings menu.

## Frequently Asked Questions ##

If you have any questions please ask on the [support forum](https://wordpress.org/support/plugin/tweet-old-post/) and we will try our best to assist.

**Is the Social Media Scheduling feature free?**

- Yes, in the free plugin you can set how many hours you’d like between each share(e.g 6 hours), ROP will automatically post to your social networks when the countdown is up. To set the days and time of the week this would require the [Pro plugin](https://revive.social/plugins/revive-old-post/).

**Is the Auto Publish (aka Auto Post) feature free?.**

- Yes, this feature is free for the accounts that can be connected via the free plugin (Facebook and Twitter). Once you check the option to post on publish, our plugin will do the rest.

**REST API error**

- This issue is normally caused by an antimalware or firewall plugin. Please try disabling all plugins(except Revive Old Posts) to see if the issue persists. If not then enable each plugin one by one while checking Revive Old Posts dashboard to see if the issue returns, that will help you determine the conflicting plugin.

**Why isn't sharing working?.**

- Your website Cron might be faulty. This is a common WordPress issue with many plugins, see our solution doc [here](https://docs.revive.social/article/686-fix-revive-old-post-not-posting) for fixing the issue.

**Does Revive Old Posts have Social media share buttons?**

- No, the plugin does not have share buttons currently. You can vote for it on our [RoadMap here](https://trello.com/b/svAZqXO1/roadmap-revive-old-posts).

**Which link shorteners are included in ROP?**

- The link shorteners the plugin currently supports are: bit.ly, is.gd, rviv.ly, google firebase, rebrandly and native WordPress shortlinks.

**Can Revive Old Posts share Posts from WordPress to Facebook Group?**

- Yes, this however requires the pro version of the plugin.

**Can Revive Old Posts share to Instagram Business page?**

- Yes, ROP can share to Instagram business page as well as personal profiles.

**Can Revive Old Posts share to LinkedIn Business page?**

- Yes, ROP can share to LinkedIn business pages as well as personal profiles.

**Any more questions or doubts?**

- Contact us at [HERE.](http://revive.social/support/) (enter "free" in the license field)

## Screenshots ##

1. Revive Old Posts dashboard(no accounts connected).
2. Add account modal
3. Facebook page and Twitter account connected
4. General settings tab, only a few of the available settings are shown in this screenshot
5. Post Format page, fine-tune your posting format per connected account
6. Custom Scheduling (PRO)
7. Sharing queue
8. Sharing Log


for more you can check out

http://revive.social/plugins/revive-old-post


## Changelog ##
### 8.5.12 - 2020-08-03  ###

* Fix PRO: Edge case where "Share Scheduled Posts to Social Media On Publish" feature would not share posts because of empty array.
* Change: Switched Facebook API calls to Graph API 7.0
* Info: Tested on WP 5.5 RC1


### 8.5.11 - 2020-07-23  ###

* Fix: Posts always sharing as image posts even with option unchecked.
* Info: Added "rop_instant_share_message" filter for manipulating custom instant share messages.


### 8.5.10 - 2020-07-21  ###

* New PRO: You can now share your website posts to your Google My Business location(s).
* Fix PRO: Unknown service error when using "Share Scheduled Posts to Social Media On Publish" feature.
* Fix PRO: Missing media type error(silent) when "Share as image Post" feature was used for Twitter.
* Info: Added checks to help prevent duplicate post issues which can occur in some environments with database caching.


### 8.5.9 - 2020-07-20  ###

* New PRO: You can now share your website posts to your Google My Business location(s).
* Fix PRO: Unknown service error when using "Share Scheduled Posts to Social Media On Publish" feature.
* Fix PRO: Missing media type error(silent) when "Share as image Post" feature was used for Twitter.
* Info: Added checks to help prevent duplicate post issues which can occur in some environments with database caching.


### 8.5.8 - 2020-06-16  ###

* New PRO: Custom instant sharing messages. You can now alter the caption that would be sent to the social media network.
* Change: Opened up easier LinkedIn login workflow for old installs.
* Change: Increased default category hashtag length. Old value was causing users categories to get dropped before sharing if they were too long


### 8.5.7 - 2020-05-14  ###

* New PRO: Made it easier to connect Tumblr accounts for new installs.
* New: Added an option in general settings to make Instant Share feature truly immediate and more reliable.
* Change: Edited some text titles and descriptions in the plugin dashboard to make them easier to understand.
*


### 8.5.6 - 2020-04-15  ###

* Change: Switched rviv.ly shortener with is.gd shortener to prevent issues with sharing.


### 8.5.5 - 2020-04-11  ###

* Fix PRO: PHP Error when "Post with image" is checked in Post format for LinkedIn and post has no featured image set.
* Fix PRO: PHP Error when no post format option is available in the database and ROP tries to share a WP scheduled post that has become published.
* Change: Bit.ly now uses bit.ly's v4 API endpoint.
* Info: Tested on WP 5.4.


### 8.5.4 - 2020-03-18  ###

* New PRO: Taxonomy filtering is now account-based
* Fix: Fixed an issue where the connected accounts would not drop down after clicking the "Share immediately using Revive Old Posts" button
* Change: Changed the function the "share immediately using Revive Old Posts" feature uses to set the cron task time
* Info: Tested on WP 5.4 RC


### 8.5.3 - 2020-02-13  ###

* Fix PRO: Fixed an issue where custom images could not be uploaded from the share queue.
* Fix PRO: Fixed an issue where it would not be possible to activate some LinkedIn accounts due to their LinkedIn ID format.
* Fix: Strip Divi shortcodes that are created by the Divi theme before the content is shared.
* Fix: Share immediately details were being saved in the DB for posts that were still drafts.
* Change: Optimized text for some log error messages and introduced known error fixes for a few others.


### 8.5.2 - 2019-12-31  ###

* New PRO: Share posts that have been scheduled for future publication by WordPress when their status change from "Scheduled" to "Publish" [Learn more](https://docs.revive.social/article/1194-share-scheduled-posts-to-social-media-on-publish-with-revive-old-posts)
* Fix PRO: Better compatibility for grabbing images for Tumblr shares on WPEngine hosted websites.
* Fix PRO: Tumblr URL shares were not showing the Link preview image.
* Fix: Instant sharing options set on the General Settings tab were not being honored.
* Fix: Corrected support doc URL for a LinkedIn error.
* Fix: Strip Divi builder shortcodes from the content before sharing to prevent undesired share output.
* Change: Videos selected for sharing in Media gallery will always be uploaded as a native video to Twitter regardless of "Post with image" option.
* Change: Call for Facebook URL scrape will now occur on original URL instead of the processed URL.
* Info: Added "Learn more" links for certain setting options on the plugin dashboard


### 8.5.1 - 2019-11-21  ###

* Fix PRO: LinkedIn invalid scope error on old installs


### 8.5.0 - 2019-11-21  ###

* New PRO: Made it easier to connect LinkedIn Accounts for new installs
* New PRO: Plugin will now grab LinkedIn company pages using when using "Sign into LinkedIn" option on the LinkedIn service inside ROP dashboard for new installs
* New PRO: Easier addition of Instagram accounts and Facebook Groups using Buffer integration
* New PRO: Ability to add custom images to post share variations
* Fix PRO: Fixed an issue where Pinterest sharing failed on some hosts
* Fix: Post immediately feature not working in Gutenberg
* Change: Moved post immediately feature to metabox
* Change: Opened up easier Twitter login workflow for old installs
* Change: Sharing as an article post to Facebook no longer requires varifying domain with Facebook Business Manager
* Change: Scrape post details before sharing to Facebook to ensure link preview is always up to date
* Change: Enhance tutorial pointers
* Change: Plugin Roadmap link added to submenu (Vote for features you want to see in ROP!)
* Info: Tested on WP 5.3


### 8.4.4 - 2019-10-03  ###

* New: Label to show sharing status.
* Change: Removed some UI buttons and made UX improvements to dashboard.
* Change: Send posts to Facebook as text posts if users have not verified their domain with Facebook; inform users on how to go about the process. .


### 8.4.3 - 2019-09-12  ###

* New: Toast message will now show on ROP dashboard when an error is present in the log.
* New: Added a check to detect when ROP cron event is not firing.
* Fix: Switching from queue tab to another tab would refresh queue order.
* Fix: Linkedin 411 length required error.
* Fix: Users would be redirected to Tumblr homepage if credentials were wrong. An error will now be displayed.
* Fix: Pressing Twitter account button after deleting a Twitter account from ROP would refresh the page.
* Change: Edited "no accounts" text area with more details to help users get started.
* Change: Moved Support & Documentation buttons to top section of ROP dashboard.
* Change: Set rviv.ly back as default shortener.
* Change: Delete icon will now show whenever an account is deactivated


### 8.4.2 - 2019-08-23  ###

* PRO Fix: Unauthorized error when updating Pro plugin
* Fix: Error would occur if the user tried to sign in while the API credentials form fields were empty
* Fix: Timer was not stopped if all accounts were removed using "remove all accounts" button
* Fix: Removing an account and then immediately trying to add it back would attempt to validate with old API credentials


### 8.4.1 - 2019-08-19  ###

* Fix: Use own keys button was appearing in Twitter modal for old installs


### 8.4.0 - 2019-08-19  ###

* PRO: Share to Instagram, Facebook Groups, LinkedIn Company Pages via Buffer integration.
* New: Made it easier to connect Twitter accounts for new users.
* Fix: Wrong error solution doc link would sometimes be given in Log.
* Fix: Fixed a bug where the sharing queue would be duplicated when switching tabs.
* Fix: Sites with Jetpack Photon feature activated would have issues with sharing images to twitter.


### 8.3.5 - 2019-08-02  ###

* Change: Made some UX changes to plugin dashboard


### 8.3.4 - 2019-07-21  ###

* New: Roadmap & Voting button! See where ROP is headed and vote on or recommend features which matter to you.
* Fix: PHP warning when Share Immediately feature would receive a non-array of selected accounts in rare cases.
* Fix: Silent Undefined Index error where Cron would try to fire for non-set actions.
* Change: Allow users who installed ROP prior to v8.3.0 to connect their Facebook accounts using the Revive Social Facebook App. No more need to go through an App review.


### 8.3.3 - 2019-07-10  ###

* New: An email will be sent to admin email address if the "Share more than once" option is unchecked and sharing is complete
* New: Documentation and support buttons on plugin dashboard
* Fix: LinkedIn Image sharing
* Fix: Facebook sharing timeout on some servers


### 8.3.2 - 2019-05-27  ###

* Fix: Log would some times show the wrong status message for the share
* Change: Use button to show app credential fields on new installs


### 8.3.1 - 2019-05-24  ###

* Fix: Use wp_remote_request functions in favor of guzzle which was causing issues on some websites
* Fix: Posting to Pinterest board names with commas


### 8.3.0 - 2019-05-24  ###

* New: Made connecting Facebook pages to plugin much simpler.
* Fix: When using publish now feature, all services would be checked after page reload even though only one was selected.


### 8.2.5 - 2019-05-17  ###

* New: Show admin notice when WP Cron is turned off, which can cause posting issues with ROP
* Fix: LinkedIn Image posts were not going through
* Fix: Posting to some Pinterest boards with special characters was not working
* Info: Tested on WP 5.2


### 8.2.4 - 2019-04-15  ###

* Fix: Minor bugs


### 8.2.3 - 2019-04-10  ###

* New: Filter introduced for Post Title & Content separator (check revive.social docs)
* New: Known errors will now show a link to the fix in the log area
* Fix: Twitter images would not share for sites which moved to a different protocol but didn't update their image links in the database
* PRO Fix: Moved to LinkedIn API v2 (check revive.social docs)


### 8.2.2 - 2019-03-20  ###

* New: Feedback button on plugin dashboard. Help us make ROP better by filling out the form!
* Fix: Minor typos
* PRO: You can now share custom messages/share variations in the order they were added.
* PRO Change: Updated custom messages/share variations metabox design


### 8.2.1 - 2019-03-01  ###

* Fix: Sharing queue issue with sites running WPML plugin


### 8.2.0 - 2019-02-09  ###

* New: The share post on publish feature is now in the lite version of the plugin. This should help with Facebook app review process (see revive.social docs)


### 8.1.8 - 2019-01-29  ###

* Fix: Minor bugs


### 8.1.7 - 2019-01-18  ###

* New: Adds basic support for WPML content sharing(see revive.social docs)
* Fix: Low PHP version notice was not showing the right text
* Fix: Minor bugs


### 8.1.6 - 2018-12-13  ###

* Fixed undefined variable error


### 8.1.5 - 2018-12-13  ###

* New: Made post share content filterable, you can now use post excerpt field (see docs)
* New: Pinterest shares will now link to the post on your website
* Changed: Bit.ly authentication method, old method will be deprecated in the future
* Changed: Custom message labels
* Fix: Pointer JavaScript error
* PRO Fix: Publish now feature not always showing


### 8.1.4 - 2018-12-03  ###

* New: Admin pointers for new plugin installs
* Change: Rename custom messages to "Share Variations"
* Fix: Automatically remove whitespace when adding credentials
* Fix: Excess blank space in shares caused by Gutenberg Editor
* PRO Fix: Publish now not showing on custom post types edit screens


### 8.1.3 - 2018-11-01  ###

* - Adds: Option to delete plugin settings on uninstall
* - Fix: Change twitter credential labels to match that on developer.twitter.com apps
* - Fix: Various typos
* - Fix: Issue with media library not loading when PRO plugin is installed in some cases
* - Fix: Error when other plugins also try to authenticate with Facebook
* - PRO: Adds support for magic tags for Custom Share Messages and Additional Text
* - PRO: Adds support for custom post type taxonomy hashtags
* - PRO: Adds Option to make share instantly option checked by default


### 8.1.2 - 2018-10-08  ###

* Fixed issue with hashtags in content
* Adds notice for PHP versions lower than 5.6
* Replaced goo.gl shortener with firebase dynamic links


### 8.1.1 - 2018-09-22  ###

* Fix rebrandly shortner missing feature.
* Adds option to disable the instant sharing feature.


### 8.1.0 - 2018-09-04  ###

* Adds support for Pinterest sharing feature
* Adds support for library media sharing feature
* Adds support for immediate post sharing feature
* Changed hashtags placement for Twitter
* Fixed hashtags for Tumblr
* Fixed Jetpack staging mode check


### 8.0.9 - 2018-06-18  ###

* Fix issue with Exclude posts blank page on non-English websites.
* Adds dedicated app workflow for Twitter authentication.
* Adds tweet intent and review buttons in the header.
* Adds filter for content before sharing.


### 8.0.8 - 2018-05-25  ###

* Prevent sharing when the website is in the staging environment.
* Improve UI accessibility.
* Adds possibility to fetch more post types.
* Strip redundant shortcodes on post content sharing.


### 8.0.7 - 2018-05-10  ###

* Fix status migration issue from v7.
* Fix compatibility with the PRO version for the linkedin sharing on company pages.
* Fix compatibility with the PRO version for the thumblr sharing issues.
* Fix small typos in the plugin settings.


### 8.0.6 - 2018-05-08  ###

* Fix hashtags issue when using post content as a source.
* Fix LinkedIn broken link when no image is used.
* Fix issue with sharing when multiple accounts are used with different custom schedules.
* Adds link only in the preview, remove from facebook message content.
* Adds limit for the number of logs.


### 8.0.5 - 2018-05-04  ###

* Fix issue with common hashtags using post content.
* Fix issue with add service when an account was removed from the list.
* Fix issue with cron lag between shares
* Improve disable state for pro services.
* Fix exclude posts inconsistency.
* Fix incomplete UTM tags on certain shortners.
* Fix refresh queue on start sharing.
* Fix freezing message in frontend when the sharing is happening.
* Fix Facebook limits regarding the number of accounts fetched.
* Fix compatibility with PRO version regarding sharing on LinkedIn.


### 8.0.4 - 2018-05-02  ###

* Fix issue with UTM tags and shortner consistency.
* Adds Exclude Posts as a separate page.
* Fix issue with sharing stopped after the first share.
* Fix timeline events refresh when the min interval changes.
* Fix Facebook page accounts not showing in certain environments.
* Adds remove account feature for permanently delete an account from the list.


### 8.0.3 - 2018-04-28  ###

* Fix schedule synchronization issues.
* Fix LinkedIn authentication with the wrong redirect_url.


### 8.0.2 - 2018-04-27  ###

* Fix issue with old Facebook applications and strict OAuth urls settings.
* Fix issue taxonomies filter setting.
* Fix filter by excluded posts issue.
* Fix issue when LinkedIn exceptions on login.
* Adds more exceptions handling for Facebook authentications.
* Fix compatibility with pro version for post_types and custom share messages.


### 8.0.1 - 2018-04-26  ###

* Fix Linkedin error on loading SDK class.
* Fix multiple twitter accounts warning message.
* Fix foreach loop on the services model.
* Fix Facebook authentication issues with application url.
* Adds notice when using an old Pro version.


### 8.0.0 - 2018-04-26  ###

* Major improvements to the codebase.
* Adds schedule and format per accounts, not per networks as it was before.
* Improve settings UI as well as the accounts authentication workflow.
* Improve posts selections per accounts.
* Improves logs reporting and messages.
* Adds major improvements to schedules trigger, implementing a new way of using wp-cron events for the plugin sharing.



**New in v7.4.8**

*   Fixed facebook display users popup.

**New in v7.4.7**

*   Fixed issue with settings cleared after update/deactivate
*   Fixed issue with posts queue
*   Added default shortner rviv.ly


**New in v7.4.5**

*   Improved schedule trigger for posts
*   Fixed issue with plugin starting
*   Fixed issue with post format

**New in v7.4.0**

*   Added support for custom messages
*   Fixes issue with multiple taxonomies having the same name
*   Fixed instructions for popups

**New in v7.3.8**

*  Improved categories excluding UI in the General tab
*  Improved design of the social networks authorization popups
*  Added more shortners
*  Fixed issue with wrong tags fetch



**New in v7.3.7**

* Fixed issue with inverted settings in post format and custom schedule

**New in v7.3.6**

* Fixed issue sample post rendering
* Improved error logging for facebook request
* Fixed typos in facebook description
* Added default tab for Manage Queue

**New in v7.3.5**

* Fixed issue with encoding
* Fixed issue with shortners and slow loading
* Fixed layout issue for posts with images in Manage Queue

**New in v7.3.2**

* Fixed issue with exclude posts

**New in v7.3.1**

* Fixed compatibility with old php versions.

**New in v7.3**

* Added Manage queue timeline.
* Fixed responsive issues
* Fixed issue with is.gd

**New in v7.2**

* Fixed randomization algorithm, preventing sharing of same post twice until the end of cycle.
* Fixed date range selection when both values are 0


**New in v7.1**

* Fixed inconsistency in the schedule. Now posting is more accurate.
* Fixed image sharing issue which was not working for some server configuration


**New in v7.0.8**

* Added facebook tutorial for facebook share.
* Fixed multisite issue for redirect url
* Making translation ready for new wordpress.org system
* Fixed single quotes problem
* Fixed tumblr tags

**New in v7.0.4**

* Changed pro banner.
* Fixed bugs with the new facebook api changes.

**New in v7.0.2**

* Removed twitter update_with_media call.
* Fixed activation error notices when WP_DEBUG was enabled

**New in v7.0**

* Fixed issue with duplicate posting
* Added Xing and Tumbr Networks
* Fixed issue with random posts on large databases.

**New in v6.9.6**

* Fixed issue cron stop
* Fixed issue for excluded post
* Added exclude posts from custom post types.


**New in v6.9.4**

* Fixed issue with share more than once option


**New in v6.9.3**

* Improved logging system
* Fixed vulnerability issue with update options
* Fixed issues with custom schedule timing
* Improved excluded category design
* Fixed excluded post selection issue


**New in v6.8.8**

Added a more complex logging system
Fixed multiple accounts/posts issue
Fixed 404 twitter login error

**New in v6.8.5**

Completely reworked how cron is working
Separated post format by network
Added support for custom schedule
Added remote cron trigger feature

**New in v6.8.2**

Fixed no available posts issue

**New in v6.8.1**

Added language support and custom post types

**New in v6.8**

Added Facebook and Linkedin

**New in v6.7**

Fixed interrupted posting issue

**New in v6.6**

Fixed excluded category issue and some small others.

**New in v6.7.7**

Added Facebook and Linkedin, Facebook is also enabled for the free users
Improved Post with image feature, we can also pull the image from post
Fixed Tweet over 140 chars error
Added Google Analytics Campaign Tracking
Rebranded into Revive Old Posts

**New in v6.7.5**

Fixed some debug messages

**New in v6.7.3**

Added settings link, fixed tweet cutting and added cron debug messages

**New in v6.6**

Fixed excluded category issue and some small others.

**New in v6.0**

Tweets now are posted immediately, fixed scheduling and added debug messages

**New in v5.9**

Tags are converted to lowercase automatically now

**New in v5.8**

Added post by image options in the pro version and some fixes.

**New in v5.7**

Fixed permissions

**New in v5.6**

Added bit.ly back

**New in v5.5**

Fixed the table prefix issue

**New in v5.4**

Fixed the hashtags length issue

**New in v5.3**

Fixed the custom field issue

**New in v5.2**

Fixed exclude categories error, added wp short url, fixed oauth error, removed broken shorten services.

**New in v5.0**

- Whole plugin was rewrote from scratch and a pro version was added, so after 50 hours of work, here we are. This change will allow us to easier fix issues/ release new features and maintain the plugin.

**New in v4.0.9**

- Resolved twitter connectivity issue, for users who were not able to connect in 4.0.8. Twitter has changed their policy
as per https://dev.twitter.com/discussions/24239



**New in v4.0.8**

- Resolved twitter connectivity issue. Twitter has changed their policy
as per https://dev.twitter.com/discussions/24239



**New in v4.0.7**

- Resolved tweet not posting issue.


**New in v4.0.6**

- Changed how pages are navigated. Should not conflict with any of the plugin that interacts with twitter ever.
- For "Page not found", update the settings and then authorize with twitter.
- If you are not able to update anything or you are redirecting to your home page, reset the settings and try again.
- Code Cleanup.


**New in v4.0.5**

- Implemented Twitter API v1.1 as Twitter is retiring API v1 from 7th May.
- Handled conflict with BackWPup plugin.
- Some performance improvements with WPSuperCache plugin.
- Some design changes.
- Code Cleanup.


**New in v4.0.4**

- Resolved issue of tweet not posting automatically. Thanks to Daniel Lopez Gonzalez for helping me.
- Minor Fixes


**New in v4.0.3**

- Handled too many tweets when W3 Total Cache plugin is installed. Please check and let me know.
- Bug fixes


**New in v4.0.2**

- Removed the option to specify the consumer key and secret as twitter does not show the application from which its tweeted anymore.
- Most probably, the tweet not posting automatically issue is resolved. Please check and let me know.
- Bug fixes


**New in v4.0.1**

- Resolved issue of page getting blank after returning from twitter
- added pages to exclude post option
- Bug fixes
- updated the steps of creating twitter application check here http://www.ajaymatharu.com/major-update-to-tweet-old-post/


**New in v4.0.0**

- You can now change the application name. Change via Tweet Old Post to your specified name. Follow the Steps here,
http://www.ajaymatharu.com/major-update-to-tweet-old-post/
- Pages can now be included in tweets. Added an option to select what is to be tweeted (pages, posts, or both).
- Removed "." and used "-" when adding additional text, "." was causing grammatical mistakes if sentence was trimmed.
- Added option to specify number of posts that can be tweeted simultaneously. You can specify how many tweets you want at a time.
- Last but not the least, removed random time slot was causing lot of confusion.



**New in v3.3.3**

- Resolved permission issue of exclude post.



**New in v3.3.2**

- Resolved too many redirects issue
	If its still not working try these steps
		- Make sure "Tweet Old Post Admin URL (Current URL)" is showing your current URL.
		- Click on "Update Tweet Old Post Options".
		- Try to authorize again.
- Removed "_" from hashtags. Previously space in hashtag was replaced with "_". Now there will be no spaces or "_" in hashtags.



**New in v3.3.1**

- Changed logic for posting data to twitter.
- Resolved bit.ly issue.



**New in v3.3.0**

- Attempt to fix logs out issue (Tweet Old Post pushes out when any action is performed).



**New in v3.2.9**

- Option to reset setting. When something goes wrong, please reset the settings and setup again.
- For people still facing issues of conflict with Google Analytics Plugin, this version should work.
- Minor bug fixes.



**New in v3.2.8**

- Resolved conflict with Google Analytics Plugin.
- Changed the log file location to root of plugin folder.
- Maintained Tweet Cycle. Repeat only when all post have been tweeted.
- Made other optimizations and resolved some minor bugs.



**New in v3.2.7**

- Added logging for people who cant make it work can enable and check the log, or mail me the log file.
- Brought back the exclude post option.
- Made other optimizations and resolved some minor bugs.
- Check http://www.ajaymatharu.com/tweet-old-post-update-3-2-7/ for more detailed explanation.



**New in v3.2.6**

- removed exclude post due to security threat. Will work on it and bring it up back.



**New in v3.2.5**

- Resolved hashtag not posting issue.
- other bug fixes.



**New in v3.2.4**

- Bug fixes



**New in v3.2.3**

- Bug fixes



**New in v3.2.2**

- Resolved bit.ly issue
- new option for hashtags
- other bug fixes



**New in v3.2.1**

- Bug fixes



**New in v3.2**

- Bug fixes
- Option to choose to include link in post
- option to post only title or body or both title and body
- option to set additional text either at beginning or end of tweet
- option to pick hashtags from custom field



**New in v3.1.2**

- Resolved tweets not getting posted when categories are excluded.
- If you are not able to authorise your twitter account set you blog URL in Administration → Settings → General.



**New in v3.1**

- Resolved issue of plugin flooding twitter account with tweets.
- added provision to exclude some post from selected categories



**New in v3.0**

- added OAuth authentication
- user defined intervals
- may not work under php 4 requires php 5



**New in v2.0**

- added provision to select if you want to shorten the URL or not.
- Cleaned other options.



**New in v1.9**

- Removed PHP 4 support as it was creating problem for lot of people



**New in v1.8**

- Bug Fixes
- Provision to fetch tweet url from custom field



**New in v1.7**

- Removed api option from 1click.at not needed api key



**New in v1.6**

- Made the plugin PHP 4 compatible. Guys try it out and please let me know if that worked.
- Better error prompting. If your tweets are not appearing on twitter. Try "Tweet Now" button you'll see if there is any problem in tweeting.
- Added 1click.at shortning service you need to get the api key from http://theeasyapi.com/ you need to add your machine IP address in the server of http://theeasyapi.com/ for this api key to work.



**New in v1.5**

- Maximum age of post to be eligible for tweet - allows you to set Maximum age of the post to be eligible for tweet
- Added one more shortner service was looking for j.mp but they dont have the api yet.



**New in v1.4**

- Hashtags - allows you to set default hashtags for your tweets



**New in v1.3**

- URL Shortener Service - allows you to select which URL shortener service you want to use.



**New in v1.2**

- Tweet Prefix - Allows you to set prefix to the tweets.
- Add Data - Allows you to add post data to the tweets
- Tweet now - Button that will tweet at that moment without wanting you to wait for scheduled tweet



**v1.1**

- Twitter Username & Password - Using this twitter account credentials plugin will tweet.
- Minimum interval between tweets - allows you to determine how often the plugin will automatically choose and tweet a blog post for you.
- Randomness interval - This is a contributing factor in minimum interval so that posts are randomly chosen and tweeted from your blog.
- Minimum age of post to be eligible for tweet - This allows you to set how old your post should be in order to be eligible for the tweet.
- Categories to omit from tweets - This will protect posts from the selected categories from being tweeted.


## Upgrade Notice ##

### 8.0.0 ###
8.0 is a major update. Make sure to backup your site before upgrading.
